<?php
/* --------------------------------------------------------------
 AbstractServiceProvider.php 2020-04-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\ServiceProviders\Abstraction;

use Gambio\Core\Application\Application;
use League\Container\ServiceProvider\ServiceProviderInterface;

/**
 * Class AbstractServiceProvider
 * @package Gambio\Core\Application\ServiceProviders\Abstraction
 */
abstract class AbstractServiceProvider implements ServiceProvider
{
    /**
     * @var Application
     */
    protected $application;
    
    
    /**
     * @inheritDoc
     */
    final public function __construct(Application $application)
    {
        $this->application = $application;
    }
    
    
    /**
     * @inheritDoc
     */
    public function toLeagueInterface(): ServiceProviderInterface
    {
        return new LeagueServiceProvider($this);
    }
    
    
    /**
     * @inheritDoc
     */
    abstract public function provides(): array;
    
    
    /**
     * Registers services and their dependencies.
     *
     * Use the `protected $application` member to register new services and their dependencies.
     *
     * Example:
     * ```php
     * $this->application->share(MyServiceInterface::class, MyServiceImplementation::class)
     *      ->addArgument(MyServiceDependency::class);
     * ```
     */
    abstract public function register(): void;
}